dnl This file is included into all any other acinclude file that
dnl needs to use these macros.

dnl This is copied from autoconf 2.12, but does calls our own
dnl AC_PROG_CC_WORKS, and doesn't call AC_PROG_CXX_GNU, cause we
dnl test for that in  AC_PROG_CC_WORKS. We are probably using a
dnl cross compiler, which will not be able to fully link an
dnl executable.  This should really be fixed in autoconf itself. 
dnl Find a working G++ cross compiler. This only works for the
dnl GNU C++ compiler.
AC_DEFUN(NILO_AC_PROG_CXX_CROSS,
[AC_BEFORE([$0], [AC_PROG_CXXCPP])
AC_CHECK_PROGS(CXX, $CCC c++ g++ gcc CC cxx cc++, gcc)

NILO_AC_PROG_GXX_WORKS

if test $ac_cv_prog_gxx = yes; then
  GXX=yes
dnl Check whether -g works, even if CXXFLAGS is set, in case the package
dnl plays around with CXXFLAGS (such as to build both debugging and
dnl normal versions of a library), tasteless as that idea is.
  ac_test_CXXFLAGS="${CXXFLAGS+set}"
  ac_save_CXXFLAGS="$CXXFLAGS"
  CXXFLAGS=
  AC_PROG_CXX_G
  if test "$ac_test_CXXFLAGS" = set; then
    CXXFLAGS="$ac_save_CXXFLAGS"
  elif test $ac_cv_prog_cxx_g = yes; then
    CXXFLAGS="-g -O2"
  else
    CXXFLAGS="-O2"
  fi
else
  GXX=
  test "${CXXFLAGS+set}" = set || CXXFLAGS="-g"
fi
])

dnl See if the G++ compiler we found works.
AC_DEFUN(NILO_AC_PROG_GXX_WORKS,
[AC_MSG_CHECKING([whether the G++ compiler ($CXX $CXXFLAGS $LDFLAGS) actually works])
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
dnl Try a test case. We only compile, because it's close to impossible
dnl to get a correct fully linked executable with a cross compiler. For
dnl most cross compilers, this test is bogus. For G++, we can use various
dnl other compile line options to get a decent idea that the cross compiler
dnl actually does work, even though we can't produce an executable without
dnl more info about the target it's being compiled for. This only works
dnl for the GNU C++ compiler.

dnl Transform the name of the compiler to it's cross variant, unless
dnl CXX is set. This is also what CXX gets set to in the generated
dnl Makefile.
if test x"${CXX}" = xc++ ; then
    CXX=`echo gcc | sed -e "${program_transform_name}"`
fi

dnl Get G++'s full path to libgcc.a
libgccpath=`${CXX} --print-libgcc`

dnl If we don't have a path with libgcc.a on the end, this isn't G++.
if test `echo $libgccpath | sed -e 's:/.*/::'` = libgcc.a ; then
   ac_cv_prog_gxx=yes
else
   ac_cv_prog_gxx=no
fi

dnl If we are using G++, look for the files that need to exist if this
dnl compiler works.
if test x"${ac_cv_prog_gxx}" = xyes ; then
    gccfiles=`echo $libgccpath | sed -e 's:/libgcc.a::'`
    if test -f ${gccfiles}/specs -a -f ${gccfiles}/cpp -a -f ${gccfiles}/cc1plus; then
	gccfiles=yes
    else
	gccfiles=no
    fi
    gcclibs=`echo $libgccpath | sed -e 's:lib/gcc-lib/.*/libgcc.a::' -e 's,\(.*\)/.*,\1,g'`/lib
    if test -d ${gcclibs}/ldscripts -a -f ${gcclibs}/libc.a -a -f ${gcclibs}/libstdc++.a ; then
	gcclibs=yes
    else
	gcclibs=no
    fi
fi

dnl If everything is OK, then we can safely assume the compiler works.
if test x"${gccfiles}" = xno -o x"${gcclibs}" = xno; then
    ac_cv_prog_cxx_works=no
    AC_MSG_ERROR(${CXX} is a non-working cross compiler)
else
   ac_cv_prog_cxx_works=yes 
fi

AC_LANG_RESTORE
AC_MSG_RESULT($ac_cv_prog_cxx_works)
if test x"$ac_cv_prog_cxx_works" = xno; then
  AC_MSG_ERROR([installation or configuration problem: C++ compiler cannot create executables.])
fi
AC_MSG_CHECKING([whether the G++ compiler ($CXX $CXXFLAGS $LDFLAGS) is a cross-compiler])
AC_MSG_RESULT($ac_cv_prog_cxx_cross)
dnl AM_CONDITIONAL(CROSS, test x$cross = xyes)
cross_compiling=$ac_cv_prog_cxx_cross
AC_SUBST(CXX)
])

dnl ====================================================================
dnl Find a working GCC cross compiler. This only works for the GNU gcc compiler.
dnl This is based on the macros above for G++.
AC_DEFUN(NILO_AC_PROG_GCC_CROSS,
[AC_BEFORE([$0], [AC_PROG_CCPP])
AC_CHECK_PROGS(CC, cc, gcc)

NILO_AC_PROG_GCC_WORKS

if test $ac_cv_prog_gcc = yes; then
  GCC=yes
dnl Check whether -g works, even if CFLAGS is set, in case the package
dnl plays around with CFLAGS (such as to build both debugging and
dnl normal versions of a library), tasteless as that idea is.
  ac_test_CFLAGS="${CFLAGS+set}"
  ac_save_CFLAGS="$CFLAGS"
  CFLAGS=
  AC_PROG_CC_G
  if test "$ac_test_CFLAGS" = set; then
    CFLAGS="$ac_save_CFLAGS"
  elif test $ac_cv_prog_cc_g = yes; then
    CFLAGS="-g -O2"
  else
    CFLAGS="-O2"
  fi
else
  GXX=
  test "${CFLAGS+set}" = set || CFLAGS="-g"
fi
])

dnl See if the GCC compiler we found works.
AC_DEFUN(NILO_AC_PROG_GCC_WORKS,
[AC_MSG_CHECKING([whether the Gcc compiler ($CC $CFLAGS $LDFLAGS) actually works])
AC_LANG_SAVE
AC_LANG_C
dnl Try a test case. We only compile, because it's close to impossible
dnl to get a correct fully linked executable with a cross
dnl compiler. For most cross compilers, this test is bogus. For G++,
dnl we can use various other compile line options to get a decent idea
dnl that the cross compiler actually does work, even though we can't
dnl produce an executable without more info about the target it's
dnl being compiled for. This only works for the GNU C++ compiler.

dnl Transform the name of the compiler to it's cross variant, unless
dnl CXX is set. This is also what CC gets set to in the generated Makefile.
if test x"${CC}" = xcc ; then
    CC=`echo gcc | sed -e "${program_transform_name}"`
fi

dnl Get Gcc's full path to libgcc.a
libgccpath=`${CC} --print-libgcc`

dnl If we don't have a path with libgcc.a on the end, this isn't G++.
if test `echo $libgccpath | sed -e 's:/.*/::'` = libgcc.a ; then
   ac_cv_prog_gcc=yes
else
   ac_cv_prog_gcc=no
fi

dnl If we are using Gcc, look for the files that need to exist if this
dnl compiler works.
if test x"${ac_cv_prog_gcc}" = xyes ; then
    gccfiles=`echo $libgccpath | sed -e 's:libgcc.a::'`
    if test -f ${gccfiles}/specs -a -f ${gccfiles}/cpp -a -f ${gccfiles}/cc1; then
	gccfiles=yes
    else
	gccfiles=no
    fi
    gcclibs=`echo $libgccpath | sed -e 's:lib/gcc-lib/.*/libgcc.a::' -e 's,\(.*\)/.*,\1,g'`/lib
    if test -d ${gcclibs}/ldscripts -a -f ${gcclibs}/libc.a -a -f ${gcclibs}/libbfd.a ; then
	gcclibs=yes
    else
	gcclibs=no
    fi
fi

dnl If everything is OK, then we can safely assume the compiler works.
if test x"${gccfiles}" = xno -o x"${gcclibs}" = xno; then
    ac_cv_prog_cc_works=no
    AC_MSG_ERROR(${CC} is a non-working cross compiler)    
else
    ac_cv_prog_cc_works=yes
fi

AC_LANG_RESTORE
AC_MSG_RESULT($ac_cv_prog_cc_works)
if test x"$ac_cv_prog_cc_works" = xno; then
  AC_MSG_ERROR([installation or configuration problem: C++ compiler cannot create executables.])
fi
AC_MSG_CHECKING([whether the Gcc compiler ($CC $CFLAGS $LDFLAGS) is a cross-compiler])
AC_MSG_RESULT($ac_cv_prog_cc_cross)
cross_compiling=$ac_cv_prog_cc_cross
AC_SUBST(CC)
])

dnl ====================================================================
dnl Find the BFD library in the build tree. This is used to access and
dnl manipulate object or executable files.
AC_DEFUN(NILO_AC_PATH_BFD, [
AC_MSG_CHECKING(for the bfd header in the build tree)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
dnl Look for the header file
AC_CACHE_VAL(ac_cv_c_bfdh,[
for i in $dirlist; do
    if test -f "$i/bfd/bfd.h" ; then
	ac_cv_c_bfdh=`(cd $i/bfd; pwd)`
	break
    fi
done
])
if test x"${ac_cv_c_bfdh}" != x; then
    BFDHDIR="-I${ac_cv_c_bfdh}"
    AC_MSG_RESULT(${ac_cv_c_bfdh})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(BFDHDIR)

dnl Look for the library
AC_MSG_CHECKING(for the bfd library in the build tree)
AC_CACHE_VAL(ac_cv_c_bfdlib,[
for i in $dirlist; do
    if test -f "$i/bfd/Makefile" ; then
	ac_cv_c_bfdlib=`(cd $i/bfd; pwd)`
    fi
done
])
dnl We list two directories cause bfd now uses libtool
if test x"${ac_cv_c_bfdlib}" != x; then
    BFDLIB="-L${ac_cv_c_bfdlib} -L${ac_cv_c_bfdlib}/.libs"
    AC_MSG_RESULT(${ac_cv_c_bfdlib})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(BFDLIB)
])

dnl ====================================================================
dnl This defines the byte order for the host. We can't use
dnl AC_C_BIGENDIAN, cause we want to create a config file and
dnl substitue the real value, so the header files work right
AC_DEFUN(NILO_AC_C_ENDIAN, [
AC_MSG_CHECKING(to see if this is a little endian host)
AC_CACHE_VAL(ac_cv_c_little_endian, [
ac_cv_c_little_endian=unknown
# See if sys/param.h defines the BYTE_ORDER macro.
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/param.h>], [
#if !BYTE_ORDER || !_BIG_ENDIAN || !_LITTLE_ENDIAN
 bogus endian macros
#endif], [# It does; now see whether it defined to _LITTLE_ENDIAN or not.
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/param.h>], [
#if BYTE_ORDER != _LITTLE_ENDIAN
 not big endian
#endif], ac_cv_c_little_endian=yes, ac_cv_c_little_endian=no)
])
if test ${ac_cv_c_little_endian} = unknown; then
old_cflags=$CFLAGS
CFLAGS=-g
AC_TRY_RUN([
main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[0] == 1);
}],
ac_cv_c_little_endian=no,
ac_cv_c_little_endian=yes,[
dnl Yes, this is ugly, and only used for a canadian cross anyway. This
dnl is just to keep configure from stopping here.
case "${host}" in
changequote(,)
   i[3456]86-*-*) ac_cv_c_little_endian=yes ;;
   sparc*-*-*)    ac_cv_c_little_endian=no ;;
changequote([,])
  *)    AC_MSG_WARN(Can't cross compile this test) ;;
esac])
CFLAGS=$old_cflags
fi])

if test x"${ac_cv_c_little_endian}" = xyes; then
    AC_DEFINE(LITTLE_ENDIAN_HOST)
    ENDIAN="NILO_LSBFIRST";
else
    ENDIAN="NILO_MSBFIRST";
fi
AC_MSG_RESULT(${ac_cv_c_little_endian})
AC_SUBST(ENDIAN)
])

dnl ====================================================================
dnl Find the linker for this cross compiler
AC_DEFUN(NILO_AC_PROG_LD_CROSS, [
AC_MSG_CHECKING(a working cross linker)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_ld_cross,[
for i in $dirlist; do
    if test -f "$i/ld/ld-new" ; then
	ac_cv_c_ld_cross=`(cd $i/ld; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_ld_cross}" = x ; then
    ac_cv_c_ld_cross=`echo ld  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_ld_cross='ld'
  fi
fi
])
if test x"${ac_cv_c_ld_cross}" != x; then
    LD="${ac_cv_c_ld_cross}"
    AC_MSG_RESULT(${ac_cv_c_ld_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(LD)
])

dnl ====================================================================
dnl Find the GAS for this cross compiler
AC_DEFUN(NILO_AC_PROG_GAS_CROSS, [
AC_MSG_CHECKING(a working cross assembler)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_gas_cross,[
for i in $dirlist; do
    if test -f "$i/gas/gas-new" ; then
	ac_cv_c_gas_cross=`(cd $i/gas; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_gas_cross}" = x ; then
    ac_cv_c_gas_cross=`echo gas  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_gas_cross='gas'
  fi
fi
])
if test x"${ac_cv_c_gas_cross}" != x; then
    GAS="${ac_cv_c_gas_cross}"
    AC_MSG_RESULT(${ac_cv_c_gas_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(GAS)
])

dnl ====================================================================
dnl Find the OBJCOPY for this cross compiler
AC_DEFUN(NILO_AC_PROG_OBJCOPY_CROSS, [
AC_MSG_CHECKING(a working cross assembler)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_objcopy_cross,[
for i in $dirlist; do
    if test -f "$i/binutils/objcopy" ; then
	ac_cv_c_objcopy_cross=`(cd $i/objcopy; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_objcopy_cross}" = x ; then
    ac_cv_c_objcopy_cross=`echo objcopy  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_objcopy_cross='objcopy'
  fi
fi
])
if test x"${ac_cv_c_objcopy_cross}" != x; then
    OBJCOPY="${ac_cv_c_objcopy_cross}"
    AC_MSG_RESULT(${ac_cv_c_objcopy_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(OBJCOPY)
])

dnl ====================================================================
dnl Find the OBJDUMP for this cross compiler
AC_DEFUN(NILO_AC_PROG_OBJDUMP_CROSS, [
AC_MSG_CHECKING(a working cross objdump)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_objdump_cross,[
for i in $dirlist; do
    if test -f "$i/binutils/objdump" ; then
	ac_cv_c_objdump_cross=`(cd $i/objdump; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_objdump_cross}" = x ; then
    ac_cv_c_objdump_cross=`echo objdump  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_objdump_cross='objdump'
  fi
fi
])
if test x"${ac_cv_c_objdump_cross}" != x; then
    OBJDUMP="${ac_cv_c_objdump_cross}"
    AC_MSG_RESULT(${ac_cv_c_objdump_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(OBJDUMP)
])

dnl ====================================================================
dnl Find the RANLIB for this cross compiler
AC_DEFUN(NILO_AC_PROG_RANLIB_CROSS, [
AC_MSG_CHECKING(a working cross ranlib)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_ranlib_cross,[
for i in $dirlist; do
    if test -f "$i/binutils/ranlib" ; then
	ac_cv_c_ranlib_cross=`(cd $i/ranlib; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_ranlib_cross}" = x ; then
    ac_cv_c_ranlib_cross=`echo ranlib  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_ranlib_cross='ranlib'
  fi
fi
])
if test x"${ac_cv_c_ranlib_cross}" != x; then
    RANLIB="${ac_cv_c_ranlib_cross}"
    AC_MSG_RESULT(${ac_cv_c_ranlib_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(RANLIB)
])

dnl ====================================================================
dnl Find the AR for this cross compiler
AC_DEFUN(NILO_AC_PROG_AR_CROSS, [
AC_MSG_CHECKING(a working cross archiver)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_ar_cross,[
for i in $dirlist; do
    if test -f "$i/binutils/ar" ; then
	ac_cv_c_ar_cross=`(cd $i/ar; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_ar_cross}" = x ; then
    ac_cv_c_ar_cross=`echo ar  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_ar_cross='ar'
  fi
fi
])
if test x"${ac_cv_c_ar_cross}" != x; then
    AR="${ac_cv_c_ar_cross}"
    AC_MSG_RESULT(${ac_cv_c_ar_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(AR)
])

dnl ====================================================================
dnl Find the SIZE for this cross compiler
AC_DEFUN(NILO_AC_PROG_SIZE_CROSS, [
AC_MSG_CHECKING(a working cross size)
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_CACHE_VAL(ac_cv_c_size_cross,[
for i in $dirlist; do
    if test -f "$i/binutils/size" ; then
	ac_cv_c_size_cross=`(cd $i/size; pwd)`
	break
    fi
done
if test -n $cross_compiling; then
  if test x"${ac_cv_c_size_cross}" = x ; then
    ac_cv_c_size_cross=`echo size  | sed -e "${program_transform_name}"`
  else
    ac_cv_c_size_cross='size'
  fi
fi
])
if test x"${ac_cv_c_size_cross}" != x; then
    SIZE="${ac_cv_c_size_cross}"
    AC_MSG_RESULT(${ac_cv_c_size_cross})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(SIZE)
])

dnl Find the Linux kernel sources
AC_DEFUN(NILO_AC_PATH_LINUX_SRC, [
    NILO_AC_PATH_LINUX_INC
    NILO_AC_PATH_LINUX_LIB
])

dnl Find the Linux kernel headers
AC_DEFUN(NILO_AC_PATH_LINUX_INC, [
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_MSG_CHECKING(for Linux kernel headers in the source tree)
AC_ARG_WITH(linuxinclude, [  --with-linuxinclude       directory where linux headers are], with_linuxinclude=${withval})
AC_CACHE_VAL(ac_cv_c_linuxh,[
dnl first check to see if --with-linuxinclude was specified
if test x"${with_linuxinclude}" != x ; then
  if test -f ${with_linuxinclude}/linux/kerneld.h ; then
    ac_cv_c_linuxh=`(cd ${with_linuxinclude}; pwd)`
  else
    AC_MSG_ERROR([${with_linuxinclude} directory doesn't contain headers])
  fi
fi
])
dnl next check in private source directory
dnl since ls returns lowest version numbers first, reverse its output
if test x"${ac_cv_c_linuxh}" = x ; then
    dnl find the top level Linux source directory
    for i in $dirlist; do
        if test -n "`ls -dr $srcdir/$i/linux* 2>/dev/null`" ; then
	    linuxpath=$srcdir/$i
	    break
	fi
    done

    dnl find the exact kernel source dir. We do it this way, cause there
    dnl might be multiple version of the kernel, and we want the most
    dnl recent one.
    for i in `ls -dr $linuxpath/linux* 2>/dev/null ` ; do
        if test -f $i/include/linux/kerneld.h ; then
          ac_cv_c_linuxh=`(cd $i/include; pwd)`
          break
        fi
    done
fi

dnl Look in the standard places.
if test x"${ac_cv_c_linuxh}" = x ; then
    for i in "/usr/src"; do
        if test -n "`ls -dr $i/linux* 2>/dev/null`" ; then
	    linuxpath=$i
	    break
	fi
    done

    dnl find the exact kernel source dir. We do it this way, cause there
    dnl might be multiple version of the kernel, and we want the most
    dnl recent one.
    for i in `ls -dr $linuxpath/linux* 2>/dev/null ` ; do
        if test -f $i/include/linux/kerneld.h ; then
          ac_cv_c_linuxh=`(cd $i/include; pwd)`
          break
        fi
    done
fi

if test x"${ac_cv_c_linuxh}" != x; then
    LINUXHDIR="${ac_cv_c_linuxh}"
    AC_MSG_RESULT(${ac_cv_c_linuxh})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(LINUXHDIR)
])

dnl Find the Linux kernel libraries.
AC_DEFUN(NILO_AC_PATH_LINUX_LIB, [
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_MSG_CHECKING(for Linux kernel libraries in the source tree)
AC_ARG_WITH(linuxlib, [  --with-linuxlib       directory where linux libraries are], with_linuxlib=${withval})
AC_CACHE_VAL(ac_cv_c_linuxlib,[
dnl first check to see if --with-linuxlib was specified
if test x"${with_linuxlib}" != x ; then
  if test -f ${with_linuxlib}/inflate.c ; then
    ac_cv_c_linuxlib=`(cd ${with_linuxlib}; pwd)`
  else
    AC_MSG_ERROR([${with_linuxlib} directory doesn't contain headers])
  fi
fi
])
dnl next check in private source directory
dnl since ls returns lowest version numbers first, reverse its output
if test x"${ac_cv_c_linuxlib}" = x ; then
    dnl find the top level Linux source directory
    for i in $dirlist; do
        if test -n "`ls -dr $srcdir/$i/lib/inflate.c* 2>/dev/null`" ; then
	    linuxpath=$srcdir/$i
	    break
	fi
    done

    dnl find the exact kernel source dir. We do it this way, cause there
    dnl might be multiple version of the kernel, and we want the most
    dnl recent one.
    for i in `ls -dr $linuxpath/linux* 2>/dev/null ` ; do
        if test -f $i/lib/inflate.c ; then
          ac_cv_c_linuxlib=`(cd $i/lib; pwd)`
          break
        fi
    done
fi

dnl Look in the standard places.
if test x"${ac_cv_c_linuxlib}" = x ; then
    for i in "/usr/src"; do
        if test -n "`ls -dr $i/linux* 2>/dev/null`" ; then
	    linuxpath=$i
	    break
	fi
    done

    dnl find the exact kernel source dir. We do it this way, cause there
    dnl might be multiple version of the kernel, and we want the most
    dnl recent one.
    for i in `ls -dr $linuxpath/linux* 2>/dev/null ` ; do
        if test -f $i/lib/inflate.c ; then
          ac_cv_c_linuxlib=`(cd $i/lib; pwd)`
          break
        fi
    done
fi

if test x"${ac_cv_c_linuxlib}" != x; then
    LINUXLIB="${ac_cv_c_linuxlib}"
    AC_MSG_RESULT(${ac_cv_c_linuxlib})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(LINUXLIB)
])

dnl Find the OSKit sources
AC_DEFUN(NILO_AC_PATH_OSKIT_SRC, [
  NILO_AC_PATH_OSKIT_INC
dnl  NILO_AC_PATH_OSKIT_LIB
])

dnl Find the OSKit headers.
AC_DEFUN(NILO_AC_PATH_OSKIT_INC, [
dirlist=".. ../../ ../../.. ../../../.. ../../../../.. ../../../../../.. ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_MSG_CHECKING(for OSKit headers in the source tree)
AC_ARG_WITH(oskit, [  --with-oskitinc       directory where the OSKit headers are], with_oskitinc=${withval})
AC_CACHE_VAL(ac_cv_c_oskith,[
dnl first check to see if --with-oskitinc was specified
if test x"${with_oskitinc}" != x ; then
  if test -f ${with_oskitinc}/oskit/wimpi_event.h ; then
    ac_cv_c_oskith=`(cd ${with_oskitinc}; pwd)`
  else
    AC_MSG_ERROR([${with_oskitinc} directory doesn't contain headers])
  fi
fi
])
dnl next check in private source directory
dnl since ls returns lowest version numbers first, reverse its output
if test x"${ac_cv_c_oskith}" = x ; then
    for i in $dirlist; do
        if test -n "`ls -dr $srcdir/$i/oskit* 2>/dev/null`" ; then
	    oskitpath=$srcdir/$i
	    break
	fi
    done

    dnl find the exact oskit source dir. We do it this way, cause there
    dnl might be multiple vesions and we want the most recent one.
    for i in `ls -dr $oskitpath/oskit* 2>/dev/null ` ; do
        if test -f $i/oskit/wimpi_event.h ; then
          ac_cv_c_oskith=`(cd $i; pwd)`
          break
        fi
    done
fi


dnl Look in the standard places to see if OSKit was installed.
if test x"${ac_cv_c_oskith}" = x ; then
    for i in /usr/local /opt /home; do
        if test -n "`ls -dr $i/oskit* 2>/dev/null`" ; then
	    oskitpath=$i
	    break
	fi
    done

    dnl find the exact oskit source dir. We do it this way, cause there
    dnl might be multiple versions, and we want the most recent one.
    for i in `ls -dr $oskitpath/oskit* 2>/dev/null ` ; do
        if test -f $i/include/oskit/wimpi_event.h ; then
          ac_cv_c_oskith=`(cd $i/include; pwd)`
          break
        fi
    done

    dnl Look in the standard places.

    for i in /usr/src /usr/local/src; do
        if test -n "`ls -dr $i/oskit* 2>/dev/null`" ; then
	    oskitpath=$i
	    break
	fi
    done

    dnl find the exact oskit source dir. We do it this way, cause there
    dnl might be multiple versions, and we want the most recent one.
    for i in `ls -dr $oskitpath/oskit* 2>/dev/null ` ; do
        if test -f $i/oskit/wimpi_event.h ; then
          ac_cv_c_oskith=`(cd $i; pwd)`
          break
        fi
    done
fi

if test x"${ac_cv_c_oskith}" != x; then
    OSKITHDIR="${ac_cv_c_oskith}"
    AC_MSG_RESULT(${ac_cv_c_oskith})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(OSKITHDIR)
])


dnl Find the Etherboot sources
AC_DEFUN(NILO_AC_PATH_ETHERBOOT_SRC, [
  NILO_AC_PATH_ETHERBOOT_INC
dnl  NILO_AC_PATH_ETHERBOOT_LIB
])

dnl Find the Etherboot headers.
AC_DEFUN(NILO_AC_PATH_ETHERBOOT_INC, [
dirlist=".. ../../ ../../../ ../../../../ ../../../../../ ../../../../../../ ../../../../../../.. ../../../../../../../.. ../../../../../../../../.. ../../../../../../../../../.."
AC_MSG_CHECKING(for Etherboot headers in the source tree)
AC_ARG_WITH(etherboot, [  --with-etherbootinc       directory where the Etherboot headers are], with_etherbootinc=${withval})
AC_CACHE_VAL(ac_cv_c_etherbooth,[
dnl first check to see if --with-etherbootinc was specified
if test x"${with_etherbootinc}" != x ; then
  if test -f ${with_etherbootinc}/src/objdump86.c ; then
    ac_cv_c_etherbooth=`(cd ${with_etherbootinc}/src; pwd)`
  else
    AC_MSG_ERROR([${with_etherbootinc} directory doesn't contain headers])
  fi
fi
])
dnl next check in private source directory
dnl since ls returns lowest version numbers first, reverse its output
if test x"${ac_cv_c_etherbooth}" = x ; then
    for i in $dirlist; do
        if test -n "`ls -dr $srcdir/$i/etherboot* 2>/dev/null`" ; then
	    etherbootpath=$srcdir/$i
	    break
	fi
    done

    dnl find the exact etherboot source dir. We do it this way, cause there
    dnl might be multiple vesions and we want the most recent one.
    for i in `ls -dr $etherbootpath/etherboot* 2>/dev/null ` ; do
        if test -f $i/src/smc9000.h ; then
          ac_cv_c_etherbooth=`(cd $i/src; pwd)`
          break
        fi
    done
fi

dnl Look in the standard places.
if test x"${ac_cv_c_etherbooth}" = x ; then
    for i in "/usr/src /usr/local/src"; do
        if test -n "`ls -dr $i/etherboot* 2>/dev/null`" ; then
	    etherbootpath=$i
	    break
	fi
    done

    dnl find the exact etherboot source dir. We do it this way, cause there
    dnl might be multiple versions, and we want the most recent one.
    for i in `ls -dr $etherbootpath/etherboot* 2>/dev/null ` ; do
        if test -f $i/src/smc9000.h ; then
          ac_cv_c_etherbooth=`(cd $i/src; pwd)`
          break
        fi
    done
fi

if test x"${ac_cv_c_etherbooth}" != x; then
    ETHERBOOTHDIR="${ac_cv_c_etherbooth}"
    AC_MSG_RESULT(${ac_cv_c_etherbooth})
else
    AC_MSG_RESULT(none)
fi
AC_SUBST(ETHERBOOTHDIR)
])








