/* Nilo - A Network boot loader.

   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of Nilo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This is the include generated by configuring */
#include "niloconfig.h"
#include "trace.h"

#include <netinet/in.h>
#include <linux/if_ether.h>

#include "nilo.h"
#include "arp.h"

struct arp arp_cache[ARP_MAXENTRY];

static unsigned char eth_broadcast[6] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

void
add_to_cache(_u32 addr, unsigned char *hwaddr, enum arp_entry a)
{
        NILO_TRACE_FUNCTION;

	arp_cache[a].addr = addr;
	memcpy(arp_cache[a].hwaddr, hwaddr, sizeof(arp_cache[0].hwaddr));

        NILO_TRACE_FUNCTION_RETURN;
}

unsigned char *
lookup_addr(_u32 addr)
{
        NILO_TRACE_FUNCTION;

	if (addr == INADDR_BROADCAST)
		return (eth_broadcast);
	if (addr == arp_cache[ARP_THEM].addr)
		return (arp_cache[ARP_THEM].hwaddr);
	if (addr == arp_cache[ARP_MYSELF].addr)
		return (arp_cache[ARP_MYSELF].hwaddr);
	return (0);

        NILO_TRACE_FUNCTION_RETURN;
}



