/* Nilo - A Network boot loader.

   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of Nilo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This is the include generated by configuring */
#include "niloconfig.h"

#include "trace.h"

#include <string.h>
#include <linux/if_ether.h>
#include "nilo.h"
#include "bootp.h"

static int xid;
static char vend_magic[] = VM_RFC1048;

int
fill_bootp_request(struct bootp_t *bootp_packet, char *macaddr, long xid)
{
        NILO_TRACE_FUNCTION;

	memset(bootp_packet, 0, sizeof(*bootp_packet));
	bootp_packet->bp_op = BOOTREQUEST;
	bootp_packet->bp_xid = xid;
	bootp_packet->bp_htype = 1;
	bootp_packet->bp_hlen = 6;
	memcpy(bootp_packet->bp_chaddr, macaddr, sizeof(bootp_packet->bp_chaddr));
	memcpy(bootp_packet->bp_vend, vend_magic, sizeof(vend_magic));
	bootp_packet->bp_vend[4] = TAG_END;
	bootp_packet->bp_secs = 0;

        NILO_TRACE_FUNCTION_RETURN;
	return (sizeof(bootp_packet));
}


