#define	IPPORT_BOOTPS		67
#define	IPPORT_BOOTPC		68

#define BOOTREQUEST		1
#define BOOTREPLY		2

#define BP_CHADDR_LEN	 	16
#define BP_SNAME_LEN	 	64
#define BP_FILE_LEN		128
#define BP_VEND_LEN	 	64
#define BP_MINPKTSZ		300	/* to check sizeof(struct bootp) */

/*
 *	We use unsigned long instead of in_addr for bp_?iaddr because
 *	we don't want to drag in netinet/in.h
 */

struct bootp_t
{
	unsigned char	bp_op;			/* packet opcode type */
	unsigned char	bp_htype;		/* hardware addr type */
	unsigned char	bp_hlen;		/* hardware addr length */
	unsigned char	bp_hops;		/* gateway hops */
	unsigned long	bp_xid;			/* transaction ID */
	_u16		bp_secs;		/* seconds since boot began */
	_u16		bp_flags;		/* RFC1532 broadcast, etc. */
	_u32		bp_ciaddr;		/* client IP address */
	_u32		bp_yiaddr;		/* 'your' IP address */
	_u32		bp_siaddr;		/* server IP address */
	_u32		bp_giaddr;		/* gateway IP address */
	unsigned char	bp_chaddr[BP_CHADDR_LEN];/* client hardware address */
	char		bp_sname[BP_SNAME_LEN];	/* server host name */
	char		bp_file[BP_FILE_LEN];	/* boot file name */
	unsigned char	bp_vend[BP_VEND_LEN];	/* vendor-specific area */
	/* note that bp_vend can be longer, extending to end of packet. */
};

/*
 * Vendor magic cookie (v_magic) for RFC1048
 */
#define VM_RFC1048	{ 99, 130, 83, 99 }

/*
 * Tag values used to specify what information is being supplied in
 * the vendor (options) data area of the packet.
 */
/* RFC 1048 */
#define TAG_END			((unsigned char) 255)
#define TAG_PAD			((unsigned char)   0)
#define TAG_SUBNET_MASK		((unsigned char)   1)
#define TAG_TIME_OFFSET		((unsigned char)   2)
#define TAG_GATEWAY		((unsigned char)   3)
#define TAG_TIME_SERVER		((unsigned char)   4)
#define TAG_NAME_SERVER		((unsigned char)   5)
#define TAG_DOMAIN_SERVER	((unsigned char)   6)
#define TAG_LOG_SERVER		((unsigned char)   7)
#define TAG_COOKIE_SERVER	((unsigned char)   8)
#define TAG_LPR_SERVER		((unsigned char)   9)
#define TAG_IMPRESS_SERVER	((unsigned char)  10)
#define TAG_RLP_SERVER		((unsigned char)  11)
#define TAG_HOST_NAME		((unsigned char)  12)
#define TAG_BOOT_SIZE		((unsigned char)  13)
/* RFC 1395 */
#define TAG_DUMP_FILE		((unsigned char)  14)
#define TAG_DOMAIN_NAME		((unsigned char)  15)
#define TAG_SWAP_SERVER		((unsigned char)  16)
#define TAG_ROOT_PATH		((unsigned char)  17)
/* RFC 1497 */
#define TAG_EXTEN_FILE		((unsigned char)  18)
/* RFC 1533 */
#define TAG_NIS_DOMAIN		((unsigned char)  40)
#define TAG_NIS_SERVER		((unsigned char)  41)
#define TAG_NTP_SERVER		((unsigned char)  42)
/* DHCP maximum message size. */
#define TAG_MAX_MSGSZ		((unsigned char)  57)

extern int fill_bootp_request(struct bootp_t *bootp_packet,
	char *macaddr, long xid);
