/*
 *	These should be used where sizes are important, e.g. protocol
 *	packets.
 */


/* Stolen from netboot */
#define ETH_ALEN        6

typedef unsigned short	_u16;
typedef	unsigned int	_u32;

struct device;
struct bootp_t;
struct tftp_t;

/* The magic number is at the end because this goes at the top of 640k */
struct protocol_table
{
	unsigned char	macaddr[ETH_ALEN];
	struct device	*dev;
	struct bootp_t	*bpr;		/* pointer to bootp reply */
	void		(*bootp_handler)(long xid,
				void (*callback)(int, struct bootp_t *));
	void		(*tftp_handler)(unsigned long, short opcode,
				const char *filename, int blockno,
				void (*callback)(int, struct tftp_t *));
	int		(*wait_for_work)(void);
	unsigned long	version;
	unsigned long	magic;
};

extern void			init_system(void);
extern struct protocol_table	*init_protocol_code(void);
extern int			init_hardware(struct protocol_table *);
extern unsigned long		getxid(void);
extern void			store(char *d, char *s, int n);
