#define KERN_CODE_SEG	0x08
#define KERN_DATA_SEG	0x10
#define REAL_MODE_SEG	0x18
#define REAL_MODE_DSEG	0x20
#define CR0_PE		1

#define opsize		.byte 0x66
#define addrsize	.byte 0x67

/**************************************************************************
START - Where all the fun begins....
**************************************************************************/
/* this must be the first thing in the file because we enter from the top */
	.global	_start
_start:
	opsize
	call	_real_to_prot

#ifdef SERIAL_CONSOLE
	call	initserial
#endif
	call	main
	/* fall through */

	.globl	exit
exit:
	call	_prot_to_real
/*	we reset sp to the location just before entering main
	instead of relying on the return from main because exit
	could have been called from anywhere */
	.byte	0xb9
	.word	STACKADDR-4		/* mov $(STACKADDR-1), cx */
	mov	%ecx,%esp
	int	$0x19
	lret				/* why doesn't this lret work? */

/**************************************************************************
SLOWDOWNIO - Short delay for I/O port accesses
**************************************************************************/
	.globl	_slowdownio
	.globl	slowdownio
slowdownio:
_slowdownio:
	jmp	slow1
slow1:	jmp	slow2
slow2:	ret

/**************************************************************************
CURRTICKS - Get Time
**************************************************************************/
	.globl	_currticks
	.globl	currticks
currticks:
_currticks:
/*	push	%ebp
	mov	%esp,%ebp */
	push	%ecx
	push	%edx
	push	%ebx
	push	%esi
	push	%edi
	xor	%edx,%edx
	call	_prot_to_real
	xor	%eax,%eax
	int	$0x1a
	opsize
	call	_real_to_prot
	xor	%eax,%eax
	shl	$16,%ecx
	mov	%edx,%eax
	or	%ecx,%eax
	pop	%edi
	pop	%esi
	pop	%ebx
	pop	%edx
	pop	%ecx
/*	pop	%ebp */
	ret

#ifdef SERIAL_CONSOLE
/**************************************************************************
INITSERIAL - Initialize serial port. Stolen from lilo
**************************************************************************/
	.globl	_initserial
	.globl	initserial
sport:
	.byte	COMPORT	
sparam:
	.byte	COMPARM	/* 0xe3 == 9600N8, 0xa3 == 2400N8 */
slbase:	
	.word	0x0
initserial:
_initserial:
	push	%eax
	push	%ebx
	push	%ecx
	push	%edx
	push	%ebx
	push	%esi
	push	%edi
	xor	%ecx,%ecx
	movb	sport,%cl
	movb	sparam,%ch
	call	_prot_to_real
	opsize
	xor	%ax,%ax
	xor	%dx,%dx
	movb	%cl,%dl
	xchg	%ch,%al
	int	$0x14		/* initializes port. Base address of port is stored at 0x400 + offset */
	opsize
	call	_real_to_prot
	shl	%cx
	addl	$0x400,%ecx
	movw	(%ecx),%bx
	movw	%bx,slbase
	pop	%edi
	pop	%esi
	pop	%ebx
	pop	%edx
	pop	%ecx
	pop	%ebx
	pop	%eax
	ret	

/**************************************************************************
SERDISP - Print a character on a serial line. Stolen from lilo.
**************************************************************************/
break:
	.byte	0
serdisp:
	push	%eax           /* wait for space in the send buffer */
	addw	$5,%dx
serwait:
	inb	%dx,%al
	testb	$0x10,%al	/* break -> set break flag */
	jz	nobrk
	movb	$1,break
nobrk:	
	testb	$0x20,%al	/* ready to send ? */
	jz	serwait		/* no -> wait */
	sub	$5,%dx		/* send the character */
	pop	%eax
	outb	%al,%dx
	ret
#endif	/* SERIAL_CONSOLE */

/**************************************************************************
PUTCHAR - Print a character
**************************************************************************/
	.globl	_putchar
	.globl	putchar
putchar:
_putchar:
	push	%ebp
	mov	%esp,%ebp
	push	%ecx
	push	%ebx
	push	%esi
	push	%edi
#ifdef SERIAL_CONSOLE
	push	%edx
	movw	slbase,%dx
	orw	%dx,%dx
	jz	sputchar_skip
	movb	8(%ebp),%eax
	call	serdisp
sputchar_skip:	
	pop	%edx
#endif
#ifdef	ANSIESC
	movb	8(%ebp),%cl
	push	%ecx
	call	handleansi
	pop	%ecx
	pop	%edi
	pop	%esi
	pop	%ebx
	pop	%ecx
	pop	%ebp
	ret
#else
	movb	8(%ebp),%cl
	call	_prot_to_real
	opsize
	mov	$1,%ebx
	movb	$0x0e,%ah
	movb	%cl,%al
	int	$0x10
	opsize
	call	_real_to_prot
	pop	%edi
	pop	%esi
	pop	%ebx
	pop	%ecx
	pop	%ebp
	ret
#endif

/**************************************************************************
INT10 - Call Interrupt 0x10
**************************************************************************/
#ifdef	ANSIESC
	.globl	_int10
	.globl  int10
	.globl	_int10ret
	.globl  int10ret
int10:
_int10:
	push	%ebp
	mov	%esp,%ebp
	push	%ebx
	push	%ecx
	push	%edx
	push	%esi
	movw	8(%ebp),%esi
	movw	10(%ebp),%ebx
	movw	12(%ebp),%ecx
	movw	14(%ebp),%edx
	call	_prot_to_real
	movw	%esi,%eax
	int	$0x10
	movw	%eax,%esi
	opsize
	call	_real_to_prot
	movw	%esi,int10ret
	movw	%ebx,int10ret+2
	movw	%ecx,int10ret+4
	movw	%edx,int10ret+6
	pop	%esi
	pop	%edx
	pop	%ecx
	pop	%ebx
	pop	%ebp
	ret
int10ret:
	.word	0,0,0,0
#endif

/**************************************************************************
GETCHAR - Get a character
**************************************************************************/
	.globl	_getchar
	.globl	getchar
getchar:
_getchar:
	push	%ebx

	push	%esi
	push	%edi
	push	%ebp

#ifdef SERIAL_CONSOLE
	push	%edx
	movw	slbase,%dx
	orw	%dx,%dx
	jz	sgetchar_skip          /* no serial port available */
sgetchar_check_1:	
	addw	$5,%dx
sgetchar_check_2:	
	inb	%dx,%al
	testb	$1,%al
	jz	sgetchar_check_2
	subw	$5,%dx
	inb	%dx,%al
	andl	$0x7f,%eax
	je	sgetchar_check_1
	pop	%edx
	pop	%ebx
	ret
sgetchar_skip:	
	pop	%edx
#endif
	call	_prot_to_real
	movb	$0x0,%ah
	int	$0x16
	movb	%al,%bl
	opsize
	call	_real_to_prot
	xor	%eax,%eax
	movb	%bl,%al

	pop	%ebp
	pop	%edi
	pop	%esi

	pop	%ebx
/*	pop	%ebp */
	ret

/**************************************************************************
ISKEY - Check for keyboard interrupt
**************************************************************************/
	.globl	_iskey
	.globl	iskey
iskey:
_iskey:
	push	%ebp
/*	mov	%esp,%ebp */
	push	%ebx
	push	%esi
	push	%edi
#ifdef SERIAL_CONSOLE
	push	%edx
	movw	slbase,%dx
	orw	%dx,%dx
	jz	siskey_skip	/* no serial port, we loose */
	addw	$5,%dx
	inb	%dx,%al
	andl	$0x01,%eax
	pop	%edx
	pop	%edi
	pop	%esi
	pop	%ebx
	pop	%ebp 
	ret
siskey_skip:	
	pop	%edx
#endif
	call	_prot_to_real
	xor	%ebx,%ebx
	movb	$0x1,%ah
	int	$0x16
	opsize
	jz	1f
	movb	%al,%bl
1:
	opsize
	call	_real_to_prot
	xor	%eax,%eax
	movb	%bl,%al
	pop	%edi
	pop	%esi
	pop	%ebx
	pop	%ebp 
	ret

/**************************************************************************
GETSHIFT - Get keyboard shift state
**************************************************************************/
	.globl	_getshift
	.globl	getshift
getshift:
_getshift:
	call	_prot_to_real
	mov	$2,%ah
	int	$0x16
	mov	%ax,%bx
	opsize
	call	_real_to_prot
	xor	%eax,%eax
	mov	%bl,%al
	ret


/**************************************************************************
MEMSIZE - Determine size of extended memory
**************************************************************************/
	.globl	_memsize
	.globl	memsize
memsize:
_memsize:
	push	%ebx
	push	%esi
	push	%edi
	call	_prot_to_real
	.byte	0xb8
	.word	0x8800
	int	$0x15
	mov	%ax,%bx
	opsize
	call	_real_to_prot
	xor	%eax,%eax
	mov	%bx,%ax
	pop	%edi
	pop	%esi
	pop	%ebx
	ret

/**************************************************************************
DISK_INIT - Initialize the disk system
**************************************************************************/
#ifdef FLOPPY
	.globl	_disk_init
	.globl	disk_init
disk_init:
_disk_init:
	push	%ecx
	push	%edx
	push	%esi
	push	%edi
	call	_prot_to_real
	xor	%eax,%eax
	movb	$0x80,%dl
	int	$0x13
	opsize
	call	_real_to_prot
	pop	%edi
	pop	%esi
	pop	%edx
	pop	%ecx
	ret
#endif

/**************************************************************************
DISK_READ - Read a sector from disk
**************************************************************************/
#ifdef FLOPPY
	.globl	_disk_read
	.globl	disk_read
disk_read:
_disk_read:
	push	%ebp
	mov	%esp,%ebp
	push	%ebx
	push	%ecx
	push	%edx
	push	%esi
	push	%edi
	movb	 8(%ebp),%dl	/* drive number    */
	movb	16(%ebp),%dh	/* head number     */
	movb	12(%ebp),%ch	/* cylinder number */
	movb	13(%ebp),%cl	/* cylinder number */
	shl	$6,%cl
	orb	20(%ebp),%cl	/* sector number   */
	movw	26(%ebp),%esi
	rorw	$4,%esi
	movw	24(%ebp),%bx	/* buffer          */
	call	_prot_to_real
	mov	$0x0201,%ax
	mov	%si,%es
	int	$0x13
	opsize
	jc	1f
	xor	%ax,%ax
1:	mov	%ax,%bx
	opsize
	call	_real_to_prot
	mov	%bx,%ax
	pop	%edi
	pop	%esi
	pop	%edx
	pop	%ecx
	pop	%ebx
	pop	%ebp
	ret
#endif

	.globl	_xstart
	.globl	xstart
xstart:  /* FIXME: this code is rather ugly! could some x86 programmer please*/
_xstart: /* come up with something better (I have no clue of x86 programming)*/
	pushl	%ebx
	pushl	%ecx
        pushl   %edx
	movw	16(%esp,1),%eax /* ugly self-modifying code! */
	movw	%eax,2f+2
	movw	$0x0,2f+4
	movw	18(%esp,1),%eax
	movw	%eax,2f+6
	movl	24(%esp,1),%ecx /* bootp record (32bit pointer) */
	add	$28,%ecx	/* ip, udp header */
	shll	$12,%ecx
	shr	$12,%cx
	movl	20(%esp,1),%ebx
	call	_prot_to_real
	opsize
	ljmp	$(RELOC>>4),$1f-RELOC /* flush cache? */
1:	nop
	opsize
	pushl	%ecx   /* bootp record */
	opsize
	pushl	%ebx   /* file header */
        opsize
        movl    $((RELOC<<12)+(3f-RELOC)),%eax
        opsize
        pushl   %eax
2:      opsize
        ljmp    $(RELOC>>4),$3f-RELOC
3:      opsize
	popl	%eax
	opsize
	popl	%eax
	opsize	
	call	_real_to_prot
        popl    %edx
	popl	%ecx
	popl	%ebx
	ret

	.globl	_setjmp
	.globl	setjmp
setjmp:
_setjmp:
	movl	4(%esp),%ecx 
	movl	0(%esp),%edx
	movl	%edx, 0(%ecx)
	movl	%ebx, 4(%ecx)
	movl	%esp, 8(%ecx)
	movl	%ebp,12(%ecx)
	movl	%esi,16(%ecx)
	movl	%edi,20(%ecx)
	movl	%eax,24(%ecx)
	movl	$0,%eax
	ret

	.globl	_longjmp
	.globl	longjmp
longjmp:
_longjmp:
	movl	4(%esp),%edx
	movl	8(%esp),%eax
	movl	0(%edx),%ecx
	movl	4(%edx),%ebx
	movl	8(%edx),%esp
	movl	12(%edx),%ebp
	movl	16(%edx),%esi
	movl	20(%edx),%edi
	cmpl	$0,%eax
	jne	1f
	movl	$1,%eax
1:	movl	%ecx,0(%esp)
	ret

/**************************************************************************
REAL_TO_PROT - Go from REAL mode to Protected Mode
**************************************************************************/
	.globl	_real_to_prot
	.globl	real_to_prot
real_to_prot:
_real_to_prot:
	cli
	cs
	addrsize
	lgdt	gdtarg-RELOC 
	mov	%cr0, %eax
	opsize
	or	$CR0_PE, %eax
	mov	%eax, %cr0		/* turn on protected mode */

	/* jump to relocation, flush prefetch queue, and reload %cs */
	opsize
	ljmp	$KERN_CODE_SEG, $1f
1:
	/* reload other segment registers */
	movl	$KERN_DATA_SEG, %eax
	movl	%ax, %ds
	movl	%ax, %es
	movl	%ax, %ss
	add	$RELOC,%esp		/* Fix up stack pointer */
	pop	%eax			/* Fix up return Address */
	add	$RELOC,%eax
	push	%eax
	ret

/**************************************************************************
PROT_TO_REAL - Go from Protected Mode to REAL Mode
**************************************************************************/
	.globl	_prot_to_real
	.globl	prot_to_real
prot_to_real:
_prot_to_real:
	pop	%eax
	sub	$RELOC,%eax		/* Adjust return address */
	push	%eax
	sub	$RELOC,%esp		/* Adjust stack pointer */
	movw	$REAL_MODE_DSEG, %ax
	ljmp	$REAL_MODE_SEG, $1f-RELOC /* jump to a 16 bit segment */
1:
	mov	%ax, %ds
	mov	%ax, %ss 
	mov	%ax, %es
	mov	%ax, %fs

	/* clear the PE bit of CR0 */
	mov	%cr0, %eax
	opsize
	andl 	$0!CR0_PE, %eax
	mov	%eax, %cr0

	/* make intersegment jmp to flush the processor pipeline
	 * and reload CS register
	 */
	opsize
	ljmp	$(RELOC)>>4, $2f-RELOC
2:
	/* we are in real mode now
	 * set up the real mode segment registers : DS, SS, ES
	 */
	mov	%cs, %ax
	mov	%ax, %ds
	mov	%ax, %es
	mov	%ax, %ss
	sti
	opsize
	ret

/**************************************************************************
GLOBAL DESCRIPTOR TABLE
**************************************************************************/
	.align	4
	.globl	_gdt, _pmcs, _pmds
gdt:
_gdt:
gdtarg:
	.word	0x27			/* limit */
	.long	gdt			/* addr */
	.byte	0, 0

_pmcs:
	/* 32 bit protected mode code segment */
	.word	0xffff, 0
	.byte	0, 0x9f, 0xcf, 0

_pmds:
	/* 32 bit protected mode data segment */
	.word	0xffff, 0
	.byte	0, 0x93, 0xcf, 0

	/* 16 bit real mode code segment */
	.word	0xffff, RELOC & 0xffff
	.byte	(RELOC>>16), 0x9b, 0x00, (RELOC>>24)

	/* 16 bit real mode data segment */
	.word	0xffff, RELOC & 0xffff
	.byte	(RELOC>>16), 0x93, 0x00, (RELOC>>24)

	.align	4
