/* Define some structures used by tftp loader */

#define	TAG_MAGIC	0x1B031336L

struct imgheader
{
	unsigned long	magic;
	unsigned char	length;
	unsigned char	r[3];
	struct { unsigned short bx, ds; } location;
	struct { unsigned short ip, cs; } execaddr;
};

union infoblock
{
	unsigned short		s[256];
	unsigned long		l[128];
	struct imgheader	i;
};

struct segheader
{
	unsigned char	length;
	unsigned char	vendortag;
	unsigned char	reserved;
	unsigned char	flags;
	unsigned long	loadaddr;
	unsigned long	imglength;
	unsigned long	memlength;
};

#define		vlength(a)	(((a) & 0xF0) >> 2)

extern void handle_block(int blockno, char *data, int blocksize);
