/* Nilo - A Network boot loader.

   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of Nilo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This is the include generated by configuring */
#include "niloconfig.h"
#include "trace.h"

#include <stdarg.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include "tftp.h"
#include "vsprintf.h"
#include "printk.h"

int blocksize = 512;

int
fill_tftp_request(struct tftp_t *tftp_pkt, short opcode,
                  const char *filename, int blockno)
{
    NILO_TRACE_FUNCTION;

    tftp_pkt->opcode = htons(opcode);
    if (filename[0] == '\0')
        filename = TFTP_DEFAULT_FILENAME;
    switch (opcode)
    {
    case TFTP_RRQ:
        return (sizeof(short) + sprintf(tftp_pkt->u.rrq, "%s%coctet%c"
#ifdef	NILO_USE_LARGETFTP
                                        "blksize%c%d"
#endif
                                        , filename, 0, 0
#ifdef	NILO_USE_LARGETFTP
                                        , 0, TFTP_MAX_PACKET
#endif
            ));
        break;
    case TFTP_ACK:
        tftp_pkt->u.ack.block = htons(blockno);
        return (sizeof(short) * 2);
        break;
    default:
        printk("Don't know how to fill with packet type %d\n", opcode);
        break;
    }

    NILO_TRACE_FUNCTION_RETURN;
    return (0);
}
