#define	IPPORT_TFTP		69

#define	TFTP_DEFAULTSIZE_PACKET	512
#define	TFTP_MAX_PACKET		1432 /* 512 */

#define TFTP_RRQ		1
#define TFTP_WRQ		2
#define TFTP_DATA		3
#define TFTP_ACK		4
#define TFTP_ERROR		5
#define TFTP_OACK		6

#define TFTP_CODE_EOF		1
#define TFTP_CODE_MORE		2
#define TFTP_CODE_ERROR		3
#define TFTP_CODE_BOOT		4
#define TFTP_CODE_CFG		5

#define	TFTP_DEFAULT_FILENAME	"kernel"

struct tftp_t
{
	unsigned short	opcode;
	union {
		char	rrq[TFTP_DEFAULTSIZE_PACKET];
		struct {
			unsigned short	block;
			char		download[TFTP_MAX_PACKET];
		} data;
		struct {
			unsigned short	block;
		} ack;
		struct {
			unsigned short	errcode;
			char		errmsg[TFTP_DEFAULTSIZE_PACKET];
		} err;
		struct {
			char		data[TFTP_DEFAULTSIZE_PACKET+2];
		} oack;
	} u;
};

extern int	blocksize;

extern int	fill_tftp_request(struct tftp_t *, short opcode,
	const char *filename, int blockno);
