/* Nilo - A Network boot loader.

   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of Nilo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This is the include generated by configuring */
#include "niloconfig.h"

const unsigned char hexchars[]="0123456789abcdef";

/* Convert a buffer into an ascified representation,
   ie.. ^C is 0x03, etc... */
unsigned char *
ascify_buffer (unsigned char *p, const unsigned char *s, int x)
{
    int i;
    unsigned char *p1 = p;

    /* convert some characters so it'll look right when
       we display it */
    for (i=0 ; i<x; i++) {
        switch (s[i]) {
        case '\012':                    /* newlines */
            *p++ = '\\';
            *p++ = 'n';
            continue;
        case '\015':                    /* carriage returns */
            *p++ = '\\';
            *p++ = 'r';
            continue;
        case '\033':                    /* escape */
            *p++ = '\\';
            *p++ = 'e';
            continue;
        case '\011':                    /* tab */
            *p++ = '\\';
            *p++ = 't';
            continue;
        case '\010':                    /* backspace */
            *p++ = '\\';
            *p++ = 'b';
            continue;
        }
        
        if (s[i] < 26) {                /* modify control characters */
            *p++ = '^';
            *p++ = s[i] + '@';
            continue;
        }
        if (s[i] >= 128) {              /* modify control characters */
            *p++ = '!';
            *p++ = s[i] + '@';
            continue;
        }
        if (s[i] > 26 && s[i] < 128) {  /* no change */
            *p++ = s[i];
            continue;
        }
    }

    *p = '\0';                          /* terminate the string */

    return p1;
}

/* Convert each byte into it's hex represntation */
unsigned char *
hexify_buffer (unsigned char *p, const unsigned char *s, int x)
{
    int i;
    unsigned char *p1 = p;

    /* convert some characters so it'll look right when displayed */
    for (i=0 ; i<x; i++) {
        /* use the hex value */
        *p++ = hexchars[s[i] >> 4];
        *p++ = hexchars[s[i] & 0xf];
        *p++ = ' ';
        }

    *p = '\0';                                  // terminate the string

    return p1;
}

/* convert number NIB to a hex digit.
      param is a decimal digit.
      returns a hex digit. */
char
digit2hex(int digit)
{
  if (digit < 10)
    return '0' + digit;
  else
    return 'a' + digit - 10;
}

/* convert an ascii hex digit to a number.
      param is hex digit.
      returns a decimal digit. */
int
hex2digit (int digit)
{
if (digit == 0)
  return 0;

  if (digit >= '0' && digit <= '9')
    return digit - '0';
  if (digit >= 'a' && digit <= 'f')
    return digit - 'a' + 10;
  if (digit >= 'A' && digit <= 'F')
    return digit - 'A' + 10;

  /* shouldn't ever get this far */
  return -1;
}



