/* 
   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of Nilo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This is generated by running configure */
#include "niloconfig.h"

/* Only build in the following if it's enabled at configure time */
#ifdef NILO_USE_TRACING

#define TRACE_OUT printk
#define NILO_TRACE_MSG(x,y) TRACE_OUT (x, y)

#ifdef __cplusplus

  struct __NILO_TRACE_FUNC__ {
    const char *func;

    __NILO_TRACE_FUNC__(void) {
	TRACE_OUT("=> enter\n");
    }

    __NILO_TRACE_FUNC__(char *_func) {
        func = _func;
	TRACE_OUT("=> %s enter\n", func);
    }

    __NILO_TRACE_FUNC__(const char *_func) {
        func = _func;
	TRACE_OUT("=> %s enter\n", func);
    }

    ~__NILO_TRACE_FUNC__(void) {
	TRACE_OUT("<= %s return\n", func);
    }
};

  #define NILO_TRACE_FUNCTION	\
      __NILO_TRACE_FUNC__ __NILO_TRACE_FUNC__( __PRETTY_FUNCTION__)

  #define TMGR_DEBUGLOG_REPORT_RETURN ""
#else
  #define NILO_TRACE_FUNCTION \
      TRACE_OUT("=> %s enter\n", __PRETTY_FUNCTION__)

  #define NILO_TRACE_FUNCTION_RETURN \
      TRACE_OUT("<= %s return\n", __PRETTY_FUNCTION__)
#endif
#else  /* don't use tracing */
#define NILO_TRACE_FUNCTION ""
#define NILO_TRACE_FUNCTION_RETURN ""
#define NILO_TRACE_MSG ""
#endif


