/* Nilo - A Network boot loader.

   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of Nilo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This is the include generated by configuring */
#include "niloconfig.h"
#include "trace.h"

#include <stdarg.h>
#include <sys/types.h>
#include "vsprintf.h"

/* Utility routines */

char
*_inet_ntoa(unsigned int addr)
{
    static char	buffer[16];
    int	a[4];
    
    NILO_TRACE_FUNCTION;

    a[0] = addr >> 24;
    a[1] = (addr >> 16) & 0xFF;
    a[2] = (addr >> 8) & 0xFF;
    a[3] = addr & 0xFF;
    vsprintf(buffer, "%d.%d.%d.%d", a);

    NILO_TRACE_FUNCTION_RETURN;
    return (buffer);
}

unsigned long getxid(void)
{
	return (12345678L);
}
